<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models;

use PaypalServerSdkLib\ApiHelper;
use stdClass;

/**
 * The item details.
 */
class ItemDetails implements \JsonSerializable
{
    /**
     * @var string|null
     */
    private $itemCode;

    /**
     * @var string|null
     */
    private $itemName;

    /**
     * @var string|null
     */
    private $itemDescription;

    /**
     * @var string|null
     */
    private $itemOptions;

    /**
     * @var string|null
     */
    private $itemQuantity;

    /**
     * @var Money|null
     */
    private $itemUnitPrice;

    /**
     * @var Money|null
     */
    private $itemAmount;

    /**
     * @var Money|null
     */
    private $discountAmount;

    /**
     * @var Money|null
     */
    private $adjustmentAmount;

    /**
     * @var Money|null
     */
    private $giftWrapAmount;

    /**
     * @var string|null
     */
    private $taxPercentage;

    /**
     * @var TaxAmount[]|null
     */
    private $taxAmounts;

    /**
     * @var Money|null
     */
    private $basicShippingAmount;

    /**
     * @var Money|null
     */
    private $extraShippingAmount;

    /**
     * @var Money|null
     */
    private $handlingAmount;

    /**
     * @var Money|null
     */
    private $insuranceAmount;

    /**
     * @var Money|null
     */
    private $totalItemAmount;

    /**
     * @var string|null
     */
    private $invoiceNumber;

    /**
     * @var CheckoutOption[]|null
     */
    private $checkoutOptions;

    /**
     * Returns Item Code.
     * An item code that identifies a merchant's goods or service.
     */
    public function getItemCode(): ?string
    {
        return $this->itemCode;
    }

    /**
     * Sets Item Code.
     * An item code that identifies a merchant's goods or service.
     *
     * @maps item_code
     */
    public function setItemCode(?string $itemCode): void
    {
        $this->itemCode = $itemCode;
    }

    /**
     * Returns Item Name.
     * The item name.
     */
    public function getItemName(): ?string
    {
        return $this->itemName;
    }

    /**
     * Sets Item Name.
     * The item name.
     *
     * @maps item_name
     */
    public function setItemName(?string $itemName): void
    {
        $this->itemName = $itemName;
    }

    /**
     * Returns Item Description.
     * The item description.
     */
    public function getItemDescription(): ?string
    {
        return $this->itemDescription;
    }

    /**
     * Sets Item Description.
     * The item description.
     *
     * @maps item_description
     */
    public function setItemDescription(?string $itemDescription): void
    {
        $this->itemDescription = $itemDescription;
    }

    /**
     * Returns Item Options.
     * The item options. Describes option choices on the purchase of the item in some detail.
     */
    public function getItemOptions(): ?string
    {
        return $this->itemOptions;
    }

    /**
     * Sets Item Options.
     * The item options. Describes option choices on the purchase of the item in some detail.
     *
     * @maps item_options
     */
    public function setItemOptions(?string $itemOptions): void
    {
        $this->itemOptions = $itemOptions;
    }

    /**
     * Returns Item Quantity.
     * The number of purchased units of goods or a service.
     */
    public function getItemQuantity(): ?string
    {
        return $this->itemQuantity;
    }

    /**
     * Sets Item Quantity.
     * The number of purchased units of goods or a service.
     *
     * @maps item_quantity
     */
    public function setItemQuantity(?string $itemQuantity): void
    {
        $this->itemQuantity = $itemQuantity;
    }

    /**
     * Returns Item Unit Price.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     */
    public function getItemUnitPrice(): ?Money
    {
        return $this->itemUnitPrice;
    }

    /**
     * Sets Item Unit Price.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     *
     * @maps item_unit_price
     */
    public function setItemUnitPrice(?Money $itemUnitPrice): void
    {
        $this->itemUnitPrice = $itemUnitPrice;
    }

    /**
     * Returns Item Amount.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     */
    public function getItemAmount(): ?Money
    {
        return $this->itemAmount;
    }

    /**
     * Sets Item Amount.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     *
     * @maps item_amount
     */
    public function setItemAmount(?Money $itemAmount): void
    {
        $this->itemAmount = $itemAmount;
    }

    /**
     * Returns Discount Amount.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     */
    public function getDiscountAmount(): ?Money
    {
        return $this->discountAmount;
    }

    /**
     * Sets Discount Amount.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     *
     * @maps discount_amount
     */
    public function setDiscountAmount(?Money $discountAmount): void
    {
        $this->discountAmount = $discountAmount;
    }

    /**
     * Returns Adjustment Amount.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     */
    public function getAdjustmentAmount(): ?Money
    {
        return $this->adjustmentAmount;
    }

    /**
     * Sets Adjustment Amount.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     *
     * @maps adjustment_amount
     */
    public function setAdjustmentAmount(?Money $adjustmentAmount): void
    {
        $this->adjustmentAmount = $adjustmentAmount;
    }

    /**
     * Returns Gift Wrap Amount.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     */
    public function getGiftWrapAmount(): ?Money
    {
        return $this->giftWrapAmount;
    }

    /**
     * Sets Gift Wrap Amount.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     *
     * @maps gift_wrap_amount
     */
    public function setGiftWrapAmount(?Money $giftWrapAmount): void
    {
        $this->giftWrapAmount = $giftWrapAmount;
    }

    /**
     * Returns Tax Percentage.
     * The percentage, as a fixed-point, signed decimal number. For example, define a 19.99% interest rate
     * as `19.99`.
     */
    public function getTaxPercentage(): ?string
    {
        return $this->taxPercentage;
    }

    /**
     * Sets Tax Percentage.
     * The percentage, as a fixed-point, signed decimal number. For example, define a 19.99% interest rate
     * as `19.99`.
     *
     * @maps tax_percentage
     */
    public function setTaxPercentage(?string $taxPercentage): void
    {
        $this->taxPercentage = $taxPercentage;
    }

    /**
     * Returns Tax Amounts.
     * An array of tax amounts levied by a government on the purchase of goods or services.
     *
     * @return TaxAmount[]|null
     */
    public function getTaxAmounts(): ?array
    {
        return $this->taxAmounts;
    }

    /**
     * Sets Tax Amounts.
     * An array of tax amounts levied by a government on the purchase of goods or services.
     *
     * @maps tax_amounts
     *
     * @param TaxAmount[]|null $taxAmounts
     */
    public function setTaxAmounts(?array $taxAmounts): void
    {
        $this->taxAmounts = $taxAmounts;
    }

    /**
     * Returns Basic Shipping Amount.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     */
    public function getBasicShippingAmount(): ?Money
    {
        return $this->basicShippingAmount;
    }

    /**
     * Sets Basic Shipping Amount.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     *
     * @maps basic_shipping_amount
     */
    public function setBasicShippingAmount(?Money $basicShippingAmount): void
    {
        $this->basicShippingAmount = $basicShippingAmount;
    }

    /**
     * Returns Extra Shipping Amount.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     */
    public function getExtraShippingAmount(): ?Money
    {
        return $this->extraShippingAmount;
    }

    /**
     * Sets Extra Shipping Amount.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     *
     * @maps extra_shipping_amount
     */
    public function setExtraShippingAmount(?Money $extraShippingAmount): void
    {
        $this->extraShippingAmount = $extraShippingAmount;
    }

    /**
     * Returns Handling Amount.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     */
    public function getHandlingAmount(): ?Money
    {
        return $this->handlingAmount;
    }

    /**
     * Sets Handling Amount.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     *
     * @maps handling_amount
     */
    public function setHandlingAmount(?Money $handlingAmount): void
    {
        $this->handlingAmount = $handlingAmount;
    }

    /**
     * Returns Insurance Amount.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     */
    public function getInsuranceAmount(): ?Money
    {
        return $this->insuranceAmount;
    }

    /**
     * Sets Insurance Amount.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     *
     * @maps insurance_amount
     */
    public function setInsuranceAmount(?Money $insuranceAmount): void
    {
        $this->insuranceAmount = $insuranceAmount;
    }

    /**
     * Returns Total Item Amount.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     */
    public function getTotalItemAmount(): ?Money
    {
        return $this->totalItemAmount;
    }

    /**
     * Sets Total Item Amount.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     *
     * @maps total_item_amount
     */
    public function setTotalItemAmount(?Money $totalItemAmount): void
    {
        $this->totalItemAmount = $totalItemAmount;
    }

    /**
     * Returns Invoice Number.
     * The invoice number. An alphanumeric string that identifies a billing for a merchant.
     */
    public function getInvoiceNumber(): ?string
    {
        return $this->invoiceNumber;
    }

    /**
     * Sets Invoice Number.
     * The invoice number. An alphanumeric string that identifies a billing for a merchant.
     *
     * @maps invoice_number
     */
    public function setInvoiceNumber(?string $invoiceNumber): void
    {
        $this->invoiceNumber = $invoiceNumber;
    }

    /**
     * Returns Checkout Options.
     * An array of checkout options. Each option has a name and value.
     *
     * @return CheckoutOption[]|null
     */
    public function getCheckoutOptions(): ?array
    {
        return $this->checkoutOptions;
    }

    /**
     * Sets Checkout Options.
     * An array of checkout options. Each option has a name and value.
     *
     * @maps checkout_options
     *
     * @param CheckoutOption[]|null $checkoutOptions
     */
    public function setCheckoutOptions(?array $checkoutOptions): void
    {
        $this->checkoutOptions = $checkoutOptions;
    }

    /**
     * Converts the ItemDetails object to a human-readable string representation.
     *
     * @return string The string representation of the ItemDetails object.
     */
    public function __toString(): string
    {
        return ApiHelper::stringify(
            'ItemDetails',
            [
                'itemCode' => $this->itemCode,
                'itemName' => $this->itemName,
                'itemDescription' => $this->itemDescription,
                'itemOptions' => $this->itemOptions,
                'itemQuantity' => $this->itemQuantity,
                'itemUnitPrice' => $this->itemUnitPrice,
                'itemAmount' => $this->itemAmount,
                'discountAmount' => $this->discountAmount,
                'adjustmentAmount' => $this->adjustmentAmount,
                'giftWrapAmount' => $this->giftWrapAmount,
                'taxPercentage' => $this->taxPercentage,
                'taxAmounts' => $this->taxAmounts,
                'basicShippingAmount' => $this->basicShippingAmount,
                'extraShippingAmount' => $this->extraShippingAmount,
                'handlingAmount' => $this->handlingAmount,
                'insuranceAmount' => $this->insuranceAmount,
                'totalItemAmount' => $this->totalItemAmount,
                'invoiceNumber' => $this->invoiceNumber,
                'checkoutOptions' => $this->checkoutOptions
            ]
        );
    }

    /**
     * Encode this object to JSON
     *
     * @param bool $asArrayWhenEmpty Whether to serialize this model as an array whenever no fields
     *        are set. (default: false)
     *
     * @return array|stdClass
     */
    #[\ReturnTypeWillChange] // @phan-suppress-current-line PhanUndeclaredClassAttribute for (php < 8.1)
    public function jsonSerialize(bool $asArrayWhenEmpty = false)
    {
        $json = [];
        if (isset($this->itemCode)) {
            $json['item_code']             = $this->itemCode;
        }
        if (isset($this->itemName)) {
            $json['item_name']             = $this->itemName;
        }
        if (isset($this->itemDescription)) {
            $json['item_description']      = $this->itemDescription;
        }
        if (isset($this->itemOptions)) {
            $json['item_options']          = $this->itemOptions;
        }
        if (isset($this->itemQuantity)) {
            $json['item_quantity']         = $this->itemQuantity;
        }
        if (isset($this->itemUnitPrice)) {
            $json['item_unit_price']       = $this->itemUnitPrice;
        }
        if (isset($this->itemAmount)) {
            $json['item_amount']           = $this->itemAmount;
        }
        if (isset($this->discountAmount)) {
            $json['discount_amount']       = $this->discountAmount;
        }
        if (isset($this->adjustmentAmount)) {
            $json['adjustment_amount']     = $this->adjustmentAmount;
        }
        if (isset($this->giftWrapAmount)) {
            $json['gift_wrap_amount']      = $this->giftWrapAmount;
        }
        if (isset($this->taxPercentage)) {
            $json['tax_percentage']        = $this->taxPercentage;
        }
        if (isset($this->taxAmounts)) {
            $json['tax_amounts']           = $this->taxAmounts;
        }
        if (isset($this->basicShippingAmount)) {
            $json['basic_shipping_amount'] = $this->basicShippingAmount;
        }
        if (isset($this->extraShippingAmount)) {
            $json['extra_shipping_amount'] = $this->extraShippingAmount;
        }
        if (isset($this->handlingAmount)) {
            $json['handling_amount']       = $this->handlingAmount;
        }
        if (isset($this->insuranceAmount)) {
            $json['insurance_amount']      = $this->insuranceAmount;
        }
        if (isset($this->totalItemAmount)) {
            $json['total_item_amount']     = $this->totalItemAmount;
        }
        if (isset($this->invoiceNumber)) {
            $json['invoice_number']        = $this->invoiceNumber;
        }
        if (isset($this->checkoutOptions)) {
            $json['checkout_options']      = $this->checkoutOptions;
        }

        return (!$asArrayWhenEmpty && empty($json)) ? new stdClass() : $json;
    }
}
